clear all;
close all;

%% Load data and shift so that bandstructure can be plotted as lines

load('strip_freq_g0.mat');
gap_line = [371*ones(1,4) linspace(371,359,10) 359*ones(1,6) ...
    linspace(359,355.2,4) 355.2*ones(1,5) 355.06]*1e6;
[energy, g0] = lines_shift(Eval_mech.bands, Eval_mech.g0, gap_line);

%% Plot g0 of strip topo mode

figure(1)
hold on;
box on;
set(gca,'FontSize',18)
pbaspect([4.617 1 1])

ylim([13 20])

% xlabel('kx');
xlabel('Frequency');
ylabel('g_0^{(strip)}/2\pi (in kHz)');

topo_mode_energy = [real(energy(22,(1:6))), real(energy(21,(7:8))), ...
    real(energy(20,(9:18))), real(energy(19,(19:21))), ...
    real(energy(18,(22:29))), real(energy(17,(30)))];
topo_mode_g0 = [g0(22,(1:6)), g0(21,(7:8)), ...
    g0(20,(9:18)), g0(19,(19:21)), ...
    g0(18,(22:29)), g0(17,(30))];

% plot(sqrt(Eval_mech.kx.^2 + Eval_mech.ky.^2), topo_mode_g0/1e3, ...
% '-o', 'LineWidth', 2, 'Color', 'blue')
% plot(topo_mode_energy, topo_mode_g0/1e3, '-o', 'LineWidth', 2, 'Color', 'blue')

% Correct for outliers (physical edge state)
topo_mode_g0_correct = topo_mode_g0;

slope = (topo_mode_g0(19) - topo_mode_g0(17))/...
    (topo_mode_energy(19) - topo_mode_energy(17));
topo_mode_g0_correct(18) = topo_mode_g0(19) + ...
    slope*(topo_mode_energy(18) - topo_mode_energy(19));

slope = (topo_mode_g0(9) - topo_mode_g0(7))/...
    (topo_mode_energy(9) - topo_mode_energy(7));
topo_mode_g0_correct(8) = topo_mode_g0(9) + ...
    slope*(topo_mode_energy(8) - topo_mode_energy(9));

shift_freq = -3.523725502690544e6;
plot(topo_mode_energy + shift_freq, topo_mode_g0_correct/1e3, ...
    'Color', 'blue', 'LineWidth', 2, 'Marker', '.', ...
    'MarkerFaceColor', 'blue', 'MarkerSize', 15);
%% Plot strip band structure

figure(2);
clf;
subplot2 = subplot(1,1,1);
set(subplot2,'FontSize',16,'XTick',[-pi/geom.mech.amech -2*pi/(3*geom.mech.amech) 0 2*pi/(3*geom.mech.amech) pi/geom.mech.amech],...
    'XTickLabel',{'-\pi', '-2\pi/3', '0', '2\pi/3', '\pi'});

xlim(subplot2,[-pi/geom.mech.amech pi/geom.mech.amech]); % Band structure showing the 1st cone
ylim(subplot2,[309.2e6 351.9e6]); % Band structure showing the 1st cone

% yticks(linspace(335e6, 375e6, 5))

hold on;
box on;

% plot(sqrt(Eval_mech.kx(1:size(gap_line, 2)).^2 + Eval_mech.ky(1:size(gap_line, 2)).^2), gap_line, 'Color', 'red', 'LineStyle', 'none','Marker', '.', 'MarkerFaceColor', 'red', 'MarkerSize', 10);

% To check the bandgap
% for i=1:size(Eval_mech.bands, 1)
%     for j=1:size(Eval_mech.bands, 2)
%         plot(sqrt(Eval_mech.kx(j)^2 + Eval_mech.ky(j)^2), real(Eval_mech.bands(i,j)), 'Color', 'blue', 'LineStyle', 'none','Marker', '.', 'MarkerFaceColor', 'blue', 'MarkerSize', 15);
%         plot(-sqrt(Eval_mech.kx(j)^2 + Eval_mech.ky(j)^2), real(Eval_mech.bands(i,j)), 'Color', 'blue', 'LineStyle', 'none','Marker', '.', 'MarkerFaceColor', 'blue', 'MarkerSize', 15);
%     end
% end

% Band structure
for i=1:size(energy,1)
    plot(sqrt(Eval_mech.kx.^2 + Eval_mech.ky.^2), real(energy(i,:)), 'Color', 'blue', 'LineWidth', 3);
    plot(-sqrt(Eval_mech.kx.^2 + Eval_mech.ky.^2), real(energy(i,:)), 'Color', 'blue', 'LineWidth', 3);
end

% Topological edge state mode
plot(sqrt(Eval_mech.kx.^2 + Eval_mech.ky.^2), topo_mode_energy, 'Color', ...
    'red', 'LineWidth', 3);
plot(-sqrt(Eval_mech.kx.^2 + Eval_mech.ky.^2), topo_mode_energy, 'Color', ...
    'red', 'LineWidth', 3);


% % Physical edge state modes
% colour_edge_mode = [146/256, 146/256, 146/256, 1];
% 
% % Physical edge mode 1
% plot(sqrt(Eval_mech.kx(1:22).^2 + Eval_mech.ky(1:22).^2), real(energy(18,(1:22))), 'Color', colour_edge_mode, 'LineWidth', 3);
% plot(-sqrt(Eval_mech.kx(1:22).^2 + Eval_mech.ky(1:22).^2), real(energy(18,(1:22))), 'Color', colour_edge_mode, 'LineWidth', 3);
% 
% plot(sqrt(Eval_mech.kx(22:30).^2 + Eval_mech.ky(22:30).^2), real(energy(19,(22:30))), 'Color', colour_edge_mode, 'LineWidth', 3);
% plot(-sqrt(Eval_mech.kx(22:30).^2 + Eval_mech.ky(22:30).^2), real(energy(19,(22:30))), 'Color', colour_edge_mode, 'LineWidth', 3);
% 
% % % Physical edge mode 2
% plot(sqrt(Eval_mech.kx(1:18).^2 + Eval_mech.ky(1:18).^2), real(energy(19,1:18)), 'Color', colour_edge_mode, 'LineWidth', 3);
% plot(-sqrt(Eval_mech.kx(1:18).^2 + Eval_mech.ky(1:18).^2), real(energy(19,1:18)), 'Color', colour_edge_mode, 'LineWidth', 3);
% 
% plot(sqrt(Eval_mech.kx(18:30).^2 + Eval_mech.ky(18:30).^2), real(energy(20,18:30)), 'Color', colour_edge_mode, 'LineWidth', 3);
% plot(-sqrt(Eval_mech.kx(18:30).^2 + Eval_mech.ky(18:30).^2), real(energy(20,18:30)), 'Color', colour_edge_mode, 'LineWidth', 3);
% 
% % Physical edge mode 3
% plot(sqrt(Eval_mech.kx(1:8).^2 + Eval_mech.ky(1:8).^2), real(energy(20,1:8)), 'Color', colour_edge_mode, 'LineWidth', 3);
% plot(-sqrt(Eval_mech.kx(1:8).^2 + Eval_mech.ky(1:8).^2), real(energy(20,1:8)), 'Color', colour_edge_mode, 'LineWidth', 3);
% 
% plot(sqrt(Eval_mech.kx(8:11).^2 + Eval_mech.ky(8:11).^2), real(energy(21,8:11)), 'Color', colour_edge_mode, 'LineWidth', 3);
% plot(-sqrt(Eval_mech.kx(8:11).^2 + Eval_mech.ky(8:11).^2), real(energy(21,8:11)), 'Color', colour_edge_mode, 'LineWidth', 3);
% 
% plot(sqrt(Eval_mech.kx(26:30).^2 + Eval_mech.ky(26:30).^2), real(energy(21,26:30)), 'Color', colour_edge_mode, 'LineWidth', 3);
% plot(-sqrt(Eval_mech.kx(26:30).^2 + Eval_mech.ky(26:30).^2), real(energy(21,26:30)), 'Color', colour_edge_mode, 'LineWidth', 3);
% 
% % Physical edge mode 4
% plot(sqrt(Eval_mech.kx(1:7).^2 + Eval_mech.ky(1:7).^2), real(energy(21,1:7)), 'Color', colour_edge_mode, 'LineWidth', 3);
% plot(-sqrt(Eval_mech.kx(1:7).^2 + Eval_mech.ky(1:7).^2), real(energy(21,1:7)), 'Color', colour_edge_mode, 'LineWidth', 3);
% 
% plot(sqrt(Eval_mech.kx(7:10).^2 + Eval_mech.ky(7:10).^2), real(energy(22,7:10)), 'Color', colour_edge_mode, 'LineWidth', 3);
% plot(-sqrt(Eval_mech.kx(7:10).^2 + Eval_mech.ky(7:10).^2), real(energy(22,7:10)), 'Color', colour_edge_mode, 'LineWidth', 3);
% 
% plot(sqrt(Eval_mech.kx(27:30).^2 + Eval_mech.ky(27:30).^2), real(energy(22,27:30)), 'Color', colour_edge_mode, 'LineWidth', 3);
% plot(-sqrt(Eval_mech.kx(27:30).^2 + Eval_mech.ky(27:30).^2), real(energy(22,27:30)), 'Color', colour_edge_mode, 'LineWidth', 3);